package com.izenpe.zain.cliente.ts;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.CalcularHash;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;


public class GeneracionTimestamp {
	
	private static final String fileName = "HelloWorld.txt";

	public static void main(String[] args) {
		try {
			
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil de sello de tiempo en la peticin de Generacin
			// de firma.
			smartSignReq.setProfile(Constants.Profile.TIMESTAMPING);
			
			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartSignReq.setLanguage("es");

			// Datos a firmar. pasamos el documento original
			//smartSignReq.setInputBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			
			// Datos a firmar. pasamos el hash de documento original
			smartSignReq.setInputHashAlgorithm(Constants.DigestAlgorithm.SHA1);
			String hashDoc = CalcularHash.getHash("data/input/" + fileName);
			smartSignReq.setInputHashDigest(hashDoc);

			// Envo de la peticin.
			SmartSignResponse smartSignResp = smartSignReq.send();

			/*
			 * Se comprueba la validez de la respuesta y se escribe la respuesta
			 * de Generacin de firma PDF en un fichero en disco.
			 */
			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				String docPDF = smartSignResp.getTimeStamp();
				byte[] data = Base64.decode(docPDF);
				String destFilename = "data/output/" + fileName.substring(0, fileName.lastIndexOf(".")) + ".tst";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("El sello de tiempo se ha generado con xito.");
			} else {
				System.out.println("Error en la Generacin del sello de tiempo:" + smartSignResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}